/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;

final class Arguments
extends IdScriptableObject {
    static final long serialVersionUID = 4275508002492040609L;
    private static final String FTAG = "Arguments";
    private static final int Id_callee = 1;
    private static final int Id_length = 2;
    private static final int Id_caller = 3;
    private static final int Id_constructor = 4;
    private static final int MAX_INSTANCE_ID = 4;
    private Object callerObj;
    private Object calleeObj;
    private Object lengthObj;
    private Object constructor;
    private NativeCall activation;
    private Object[] args;

    public Arguments(NativeCall activation) {
        this.activation = activation;
        Scriptable parent = activation.getParentScope();
        this.setParentScope(parent);
        this.setPrototype(ScriptableObject.getObjectPrototype(parent));
        this.args = activation.originalArgs;
        this.lengthObj = this.args.length;
        NativeFunction f2 = activation.function;
        this.calleeObj = f2;
        Scriptable topLevel = Arguments.getTopLevelScope(parent);
        this.constructor = Arguments.getProperty(topLevel, "Object");
        int version = f2.getLanguageVersion();
        this.callerObj = version <= 130 && version != 0 ? null : NOT_FOUND;
    }

    public String getClassName() {
        return FTAG;
    }

    private Object arg(int index2) {
        if (index2 < 0 || this.args.length <= index2) {
            return NOT_FOUND;
        }
        return this.args[index2];
    }

    private void putIntoActivation(int index2, Object value2) {
        String argName = this.activation.function.getParamOrVarName(index2);
        this.activation.put(argName, (Scriptable)this.activation, value2);
    }

    private Object getFromActivation(int index2) {
        String argName = this.activation.function.getParamOrVarName(index2);
        return this.activation.get(argName, (Scriptable)this.activation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceArg(int index2, Object value2) {
        if (this.sharedWithActivation(index2)) {
            this.putIntoActivation(index2, value2);
        }
        Arguments arguments = this;
        synchronized (arguments) {
            if (this.args == this.activation.originalArgs) {
                this.args = (Object[])this.args.clone();
            }
            this.args[index2] = value2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeArg(int index2) {
        Arguments arguments = this;
        synchronized (arguments) {
            if (this.args[index2] != NOT_FOUND) {
                if (this.args == this.activation.originalArgs) {
                    this.args = (Object[])this.args.clone();
                }
                this.args[index2] = NOT_FOUND;
            }
        }
    }

    public boolean has(int index2, Scriptable start) {
        if (this.arg(index2) != NOT_FOUND) {
            return true;
        }
        return super.has(index2, start);
    }

    public Object get(int index2, Scriptable start) {
        Object value2 = this.arg(index2);
        if (value2 == NOT_FOUND) {
            return super.get(index2, start);
        }
        if (this.sharedWithActivation(index2)) {
            return this.getFromActivation(index2);
        }
        return value2;
    }

    private boolean sharedWithActivation(int index2) {
        NativeFunction f2 = this.activation.function;
        int definedCount = f2.getParamCount();
        if (index2 < definedCount) {
            if (index2 < definedCount - 1) {
                String argName = f2.getParamOrVarName(index2);
                for (int i = index2 + 1; i < definedCount; ++i) {
                    if (!argName.equals(f2.getParamOrVarName(i))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void put(int index2, Scriptable start, Object value2) {
        if (this.arg(index2) == NOT_FOUND) {
            super.put(index2, start, value2);
        } else {
            this.replaceArg(index2, value2);
        }
    }

    public void delete(int index2) {
        if (0 <= index2 && index2 < this.args.length) {
            this.removeArg(index2);
        }
        super.delete(index2);
    }

    protected int getMaxInstanceId() {
        return 4;
    }

    protected int findInstanceIdInfo(String s2) {
        int attr;
        int id = 0;
        String X = null;
        int s_length = s2.length();
        if (s_length == 6) {
            char c = s2.charAt(5);
            if (c == 'e') {
                X = "callee";
                id = 1;
            } else if (c == 'h') {
                X = "length";
                id = 2;
            } else if (c == 'r') {
                X = "caller";
                id = 3;
            }
        } else if (s_length == 11) {
            X = "constructor";
            id = 4;
        }
        if (X != null && X != s2 && !X.equals(s2)) {
            id = 0;
        }
        if (id == 0) {
            return super.findInstanceIdInfo(s2);
        }
        switch (id) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                attr = 2;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Arguments.instanceIdInfo(attr, id);
    }

    protected String getInstanceIdName(int id) {
        switch (id) {
            case 1: {
                return "callee";
            }
            case 2: {
                return "length";
            }
            case 3: {
                return "caller";
            }
            case 4: {
                return "constructor";
            }
        }
        return null;
    }

    protected Object getInstanceIdValue(int id) {
        switch (id) {
            case 1: {
                return this.calleeObj;
            }
            case 2: {
                return this.lengthObj;
            }
            case 3: {
                NativeCall caller;
                Object value2 = this.callerObj;
                if (value2 == UniqueTag.NULL_VALUE) {
                    value2 = null;
                } else if (value2 == null && (caller = this.activation.parentActivationCall) != null) {
                    value2 = caller.get("arguments", (Scriptable)caller);
                }
                return value2;
            }
            case 4: {
                return this.constructor;
            }
        }
        return super.getInstanceIdValue(id);
    }

    protected void setInstanceIdValue(int id, Object value2) {
        switch (id) {
            case 1: {
                this.calleeObj = value2;
                return;
            }
            case 2: {
                this.lengthObj = value2;
                return;
            }
            case 3: {
                this.callerObj = value2 != null ? value2 : UniqueTag.NULL_VALUE;
                return;
            }
            case 4: {
                this.constructor = value2;
                return;
            }
        }
        super.setInstanceIdValue(id, value2);
    }

    Object[] getIds(boolean getAll) {
        Object[] ids = super.getIds(getAll);
        if (this.args.length != 0) {
            int i;
            boolean[] present = new boolean[this.args.length];
            int extraCount = this.args.length;
            for (i = 0; i != ids.length; ++i) {
                int index2;
                Object id = ids[i];
                if (!(id instanceof Integer) || 0 > (index2 = ((Integer)id).intValue()) || index2 >= this.args.length || present[index2]) continue;
                present[index2] = true;
                --extraCount;
            }
            if (!getAll) {
                for (i = 0; i < present.length; ++i) {
                    if (present[i] || !super.has(i, (Scriptable)this)) continue;
                    present[i] = true;
                    --extraCount;
                }
            }
            if (extraCount != 0) {
                Object[] tmp = new Object[extraCount + ids.length];
                System.arraycopy(ids, 0, tmp, extraCount, ids.length);
                ids = tmp;
                int offset = 0;
                for (int i2 = 0; i2 != this.args.length; ++i2) {
                    if (present != null && present[i2]) continue;
                    ids[offset] = i2;
                    ++offset;
                }
                if (offset != extraCount) {
                    Kit.codeBug();
                }
            }
        }
        return ids;
    }

    protected ScriptableObject getOwnPropertyDescriptor(Context cx, Object id) {
        int index2;
        double d = ScriptRuntime.toNumber(id);
        if (d != (double)(index2 = (int)d)) {
            return super.getOwnPropertyDescriptor(cx, id);
        }
        Object value2 = this.arg(index2);
        if (value2 == NOT_FOUND) {
            return super.getOwnPropertyDescriptor(cx, id);
        }
        if (this.sharedWithActivation(index2)) {
            value2 = this.getFromActivation(index2);
        }
        if (super.has(index2, (Scriptable)this)) {
            ScriptableObject desc = super.getOwnPropertyDescriptor(cx, id);
            desc.put("value", (Scriptable)desc, value2);
            return desc;
        }
        Scriptable scope = this.getParentScope();
        if (scope == null) {
            scope = this;
        }
        return Arguments.buildDataDescriptor(scope, value2, 0);
    }

    protected void defineOwnProperty(Context cx, Object id, ScriptableObject desc, boolean checkValid2) {
        super.defineOwnProperty(cx, id, desc, checkValid2);
        double d = ScriptRuntime.toNumber(id);
        int index2 = (int)d;
        if (d != (double)index2) {
            return;
        }
        Object value2 = this.arg(index2);
        if (value2 == NOT_FOUND) {
            return;
        }
        if (this.isAccessorDescriptor(desc)) {
            this.removeArg(index2);
            return;
        }
        Object newValue = Arguments.getProperty((Scriptable)desc, "value");
        if (newValue == NOT_FOUND) {
            return;
        }
        this.replaceArg(index2, newValue);
        if (Arguments.isFalse(Arguments.getProperty((Scriptable)desc, "writable"))) {
            this.removeArg(index2);
        }
    }
}

